--[[
    "Scroller With Submenu"
	tldr you can modify it, but others shall also be allowed to modify it. 

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
]]

--Custom func that returns dict with keys instead of a list
local function custSplit(delimiter, text)
	local list = {}
	local pos = 1
	while 1 do
		local first,last = string.find(text, delimiter, pos)
		if first then
			list[string.sub(text, pos, first-1)]=true
			pos = last+1
		else
			list[string.sub(text, pos)]=true
			break
		end
	end
	return list
end

local screenName = Var("LoadingScreen")
local wrapCursor = THEME:GetMetric(screenName,"WrapCursor")

--In case you're booting to this screen
DoDebug = GAMESTATE:Dopefish() or DoDebug

if not GAMESTATE:IsSideJoined(PLAYER_1) then
	GAMESTATE:JoinPlayer(PLAYER_1);
end;
setenv("GameMode","adventure");

--if you index by keys lua can't count without using a custom iterator
local choices = {};
for _,c in ipairs(STORYDATA.CHAPTER_ORDER) do
	local f = ResolveRelativePath("ScreenNonstopInterpreter overlay/"..c..".lua",1)
	--assert(f,c.." does not point to a valid map.");
	Trace("Loading chapter "..f)
	local chapterData,e = loadfile(f);
	assert(chapterData,e);
	chapterData = chapterData(...);
	assert(#chapterData > 0,c.." has no parts or points to a nonexistent file.");
	
	local submenu = {}
	for i,p in ipairs(chapterData) do
		submenu[#submenu+1] = {
			name=p['name'];
			screen='ScreenNonstopInterpreter';
			--No need for this
			--gc='setenv,nextChapter,'..c..';setenv,nextPart,'..i;
		}
	end;
	
	choices[#choices+1] = {
		name=c;
		submenu=submenu;
	}
end;

assert(#choices > 0);

local maxNumCursorsToSpawn = 1

local mainMenuScroller;
local subMenuScrollers = {};
local helperText;

local function updateCursor(scroller,pos)
	scroller:SetDestinationItem(pos)
	SOUND:PlayOnce(THEME:GetPathS("Common", "value"), true);
	scroller:playcommand("Update");
end;

local inputLevel = 0;
local function inputHandler(event)

	local pn= event.PlayerNumber
	local button = event.button
	
	-- If it's a release, ignore it.
	if event.type == "InputEventType_Release" then return end

	if not pn then
		return 
	end
	
	
	if button == "Select" then
		SCREENMAN:SystemMessage(mainMenuScroller:GetNumItems())
		return
	end;
	
	local curScroller = mainMenuScroller;
	if inputLevel == 1 then
		curScroller = subMenuScrollers[mainMenuScroller:GetDestinationItem()+1];
	end;
	
	if button == "MenuUp" then
		if curScroller:GetDestinationItem() > 0 then
			updateCursor(curScroller, curScroller:GetDestinationItem()-1)
		elseif wrapCursor then 
			updateCursor(curScroller, curScroller:GetNumItems()-1)
		end;
	elseif button == "MenuDown" then
		if curScroller:GetDestinationItem() < curScroller:GetNumItems()-1 then
			updateCursor(curScroller, curScroller:GetDestinationItem()+1)
		elseif wrapCursor then
			updateCursor(curScroller, 0);
		end;
	elseif button == "Start" or button == "Center" then
		if inputLevel == 1 then
			local c = choices[mainMenuScroller:GetDestinationItem()+1]['submenu'][curScroller:GetDestinationItem()+1]
			setenv('nextChapter',choices[mainMenuScroller:GetDestinationItem()+1].name);
			setenv('nextPart',curScroller:GetDestinationItem()+1);
			--if c.gc then GAMESTATE:ApplyGameCommand(c.gc) end;
			assert(c.screen,"No screen set for choice "..c.name);
			SCREENMAN:GetTopScreen():SetNextScreenName(c.screen)
			SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToNextScreen")
		else
			inputLevel = 1;
			subMenuScrollers[mainMenuScroller:GetDestinationItem()+1]:playcommand("Show");
		end;
	elseif button == "Back" then
		if inputLevel == 1 then
			subMenuScrollers[mainMenuScroller:GetDestinationItem()+1]:playcommand("Hide");
			inputLevel=0;
		else
			SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToPrevScreen")
		end;
	else
		SCREENMAN:SystemMessage("unknown button: "..button);
	end;
	
	helperText:settext("Lv: "..inputLevel.." | C: "..curScroller:GetDestinationItem());
end;

local af = Def.ActorScroller{

	NumItemsToDraw=#choices*2, 
	SecondsPerItem=0,
	TransformFunction=THEME:GetMetric(screenName,"ScrollerTransform");

	InitCommand=cmd(xy,200,SCREEN_CENTER_Y;diffusealpha,1);
	OnCommand=function(self)
		mainMenuScroller = self;
		self:queuecommand("Show")
		self:GetChild(1):playcommand("GainFocus"):finishtweening();
	end;
	ShowCommand=function(self)
		self:diffusealpha(1);
	end;
	UpdateCommand=function(self)
		for i=1,#choices do			
			if self:GetDestinationItem() == i-1 then
				self:GetChild(i):playcommand("GainFocus")
			else
				--Trace(i)
				self:GetChild(i):playcommand("LoseFocus")
			end;
		end;
	end;
};
for i,choice in ipairs(choices) do
	af[#af+1] = LoadActor('testScroller',i,choice.name)
end;

local function genSubmenu(index)
	local submenu = choices[index]['submenu']
	local afs = Def.ActorScroller{

		NumItemsToDraw=#submenu*2, 
		SecondsPerItem=0,
		TransformFunction=THEME:GetMetric(screenName,"ScrollerTransform");

		InitCommand=cmd(xy,THEME:GetMetric(screenName,"SubScrollerX"),THEME:GetMetric(screenName,"SubScrollerY");diffusealpha,0);
		OnCommand=function(self)
			subMenuScrollers[index] = self;
			self:GetChild(1):playcommand("GainFocus")
			--self:queuecommand("Show")
		end;
		ShowCommand=function(self)
			self:diffusealpha(1);
		end;
		HideCommand=function(self)
			self:diffusealpha(0);
		end;
		UpdateCommand=function(self)
			for i=1,#submenu do			
				if self:GetDestinationItem() == i-1 then
					self:GetChild(i):playcommand("GainFocus")
				else
					--Trace(i)
					self:GetChild(i):playcommand("LoseFocus")
				end;
			end;
		end;
	};
	for i,choice in ipairs(submenu) do
		afs[#afs+1] = LoadActor('testScroller',i,choice.name)
	end;
	return afs;
end;

local t = Def.ActorFrame{
	OnCommand=function(self)
		SCREENMAN:GetTopScreen():AddInputCallback(inputHandler);
	end;
	LoadFont("Common Normal")..{
		Text=THEME:GetCurLanguage();
		InitCommand=cmd(Center)
	};
	LoadFont("Common Normal")..{
		InitCommand=cmd(CenterX;y,SCREEN_BOTTOM-10);
		OnCommand=function(self)
			helperText = self;
		end;
	};
	af
}

for i,choice in ipairs(choices) do
	if choice.submenu then
		t[#t+1]=genSubmenu(i);
	end;
end;


return t;
